#!/bin/bash

HOSTS=/etc/hosts
PATTERN='^[[:space:]]*127.0.0.1[[:space:]]+static3.cdn.ubi.com$'


clear

if grep -qE "$PATTERN" $HOSTS; then
    echo 'Nothing to be done - patched already.'
else
    echo "Going to patch file $HOSTS - 'sudo' may ask you for your password."
    sudo -s "cat >> $HOSTS << EOF

##
# AC2 fake/redirecting entries - remove when not needed anymore
#
127.0.0.1       static3.cdn.ubi.com
127.0.0.1       ubisoft-orbit.s3.amazonaws.com
127.0.0.1       onlineconfigservice.ubi.com
127.0.0.1       orbitservice.ubi.com
127.0.0.1       ubisoft-orbit-savegames.s3.amazonaws.com
#
# AC2 entries end
##
EOF
"

    if [ $? -eq 0 ]; then
        echo 'Done.'
    else
        echo 'Failed (not an admin user or failed to authenticate).'
    fi
fi

echo
read -n 1 -s -p 'Press any key to continue...'
echo
